﻿'================================================================================================================================================
'名称：程序通用主模块
'作者：刘飞
'作用：主要用于程序声明一些全局通用的处理

'时间：2013.11.26
'版本：V1.0
'描述：初稿
'================================================================================================================================================

'================================================================================================================================================
'各种命名空间的导入和引用
'************************************************************************************************************************************************
'************************************************************************************************************************************************
'================================================================================================================================================

'================================================================================================================================================
Module mod_Main

    '================================================================================================================================================
    '模块级级声明区域
    '================================================================================================================================================

    '================================================================================================================================================
    '************************************************************************************************************************************************
    '将程序中的设置值存储到注册表中，成功返回"",失败返回失败信息
    'SetName:值名称
    'SetValue:值
    Public Function SaveProSetting(ByVal SetName As String, ByVal SetValue As String) As String

        Try

            My.Computer.Registry.SetValue("HKEY_LOCAL_MACHINE\SOFTWARE\刘飞工作室\" & Application.ProductName, SetName, SetValue)

        Catch ex As Exception

            SaveProSetting = ex.Message
            Exit Function

        End Try

        SaveProSetting = ""

    End Function
    '************************************************************************************************************************************************

    '************************************************************************************************************************************************
    '读取指定的设置值，并将其返回
    'SetName:值名称
    Public Function ReadProSetting(ByVal SetName As String) As String

        Try

            ReadProSetting = My.Computer.Registry.GetValue("HKEY_LOCAL_MACHINE\SOFTWARE\刘飞工作室\" & Application.ProductName, SetName, "")

        Catch ex As Exception

            ReadProSetting = ""

        End Try

    End Function
    '************************************************************************************************************************************************

    '************************************************************************************************************************************************
    '删除指定的设置值，成功返回"",失败返回失败信息
    'SetName:值名称
    Public Function DelProSetting(ByVal SetName As String) As String

        Dim REG As Microsoft.Win32.RegistryKey = Microsoft.Win32.Registry.LocalMachine
        Dim REG1 As Microsoft.Win32.RegistryKey

        Try

            REG1 = REG.OpenSubKey("SOFTWARE\刘飞工作室\" & Application.ProductName, True)
            REG1.DeleteValue(SetName, False)

        Catch ex As Exception

            DelProSetting = ex.Message

        End Try

        DelProSetting = ""

    End Function
    '************************************************************************************************************************************************

    '************************************************************************************************************************************************
    '计算MODBUS_CRC16
    Public Function MODBUS_CRC16(ByVal Crc16_num() As Byte, ByVal nLength As Byte) As UInt16

        Dim i, j As UInt16
        Dim crc As UInt16

        crc = &HFFFF
        For i = 0 To nLength - 1 Step 1
            crc = crc Xor Crc16_num(i)
            For j = 0 To 7 Step 1
                If (crc And &H1) > 0 Then
                    crc = crc >> 1
                    crc = crc Xor &HA001
                Else
                    crc = crc >> 1
                End If
            Next j
        Next i

        Return crc

    End Function
    '************************************************************************************************************************************************
    '================================================================================================================================================

End Module
'================================================================================================================================================
